<?php

//Disable the default WooCommerce stylesheet.
if ( version_compare( WOOCOMMERCE_VERSION, "2.1" ) >= 0 ) {
    add_filter( 'woocommerce_enqueue_styles', '__return_false' );
} else {
    define( 'WOOCOMMERCE_USE_CSS', false );
}

if(!function_exists('hudson_edge_woo_related_products_args')) {
    /**
     * Function that sets number of displayed related products. Hooks to woocommerce_output_related_products_args filter
     * @param $args array array of args for the query
     * @return mixed array of changed args
     */
    function hudson_edge_woo_related_products_args( $args ) {
        global $hudson_edge_options;
        if(isset($hudson_edge_options['woo_products_list_number']) && $hudson_edge_options['woo_products_list_number'] != ''){
            switch($hudson_edge_options['woo_products_list_number']){
                case('columns-3') :
                    $args['posts_per_page'] = 3;
                    break;
                case('columns-4') :
                    $args['posts_per_page'] = 4;
                    break;
                default :
                    $args['posts_per_page'] = 3;
            }
        }
        else {
            $args['posts_per_page'] = 3;
        }
        return $args;
    }

    add_filter( 'woocommerce_output_related_products_args', 'hudson_edge_woo_related_products_args' );
}

// Define number of products per page.
if(!function_exists('hudson_edge_woo_product_per_page')) {
    /**
     * Function that sets number of products per page. Default is 12
     * @return int number of products to be shown per page
     */
    function hudson_edge_woo_product_per_page() {
        global $hudson_edge_options;

        $products_per_page = 12;
        if(isset($hudson_edge_options['woo_products_per_page']) && $hudson_edge_options['woo_products_per_page']) {
            $products_per_page = $hudson_edge_options['woo_products_per_page'];
        }

        return $products_per_page;
    }

    add_filter('loop_shop_per_page', 'hudson_edge_woo_product_per_page', 20);
}

// Hook in
add_filter('woocommerce_checkout_fields', 'hudson_edge_custom_override_checkout_fields');

/**
 * Remove add to cart function from woocommerce_after_shop_loop_item_title hook
 * and hook it in edgt_woocommerce_after_product_image
 */
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
add_action('edgt_woocommerce_after_product_image', 'woocommerce_template_loop_add_to_cart', 10);

/**
 * Remove related products from woocommerce_after_single_product_summary hook
 * and hook it in edgt_woocommerce_related_products.With this action(edgt_woocommerce_related_products)
 *  related products now can be hooked separately from woocommerce tabs(accordions)
 */
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
add_action('edgt_woocommerce_related_products', 'woocommerce_output_related_products', 5);


/**
 * Overrides placeholder values for checkout fields
 * @param array all checkout fields
 * @return array checkout fields with overriden values
 */
function hudson_edge_custom_override_checkout_fields($fields) {
    //billing fields
    $args_billing = array(
        'first_name' => esc_html__('First name','hudson'),
        'last_name'  => esc_html__('Last name','hudson'),
        'company'    => esc_html__('Company name','hudson'),
        'address_1'  => esc_html__('Address','hudson'),
        'email'      => esc_html__('Email','hudson'),
        'phone'      => esc_html__('Phone','hudson'),
        'postcode'   => esc_html__('Postcode / ZIP','hudson'),
        'city'       => esc_html__('City','hudson'),
        'state'       => esc_html__('State / Country','hudson')
    );
    
    //shipping fields
    $args_shipping = array(
        'first_name' => esc_html__('First name','hudson'),
        'last_name'  => esc_html__('Last name','hudson'),
        'company'    => esc_html__('Company name','hudson'),
        'address_1'  => esc_html__('Address','hudson'),
        'postcode'   => esc_html__('Postcode / ZIP','hudson'),
        'city'       => esc_html__('City','hudson'),
        'state'       => esc_html__('State / Country','hudson')
    );
    
    //override billing placeholder values
    foreach ($args_billing as $key => $value) {
        $fields["billing"]["billing_{$key}"]["placeholder"] = $value;
    }
    
    //override shipping placeholder values
    foreach ($args_shipping as $key => $value) {
        $fields["shipping"]["shipping_{$key}"]["placeholder"] = $value;
    }

    return $fields;
}

// Adds theme support for woocommerce 
add_theme_support('woocommerce');

if (!function_exists('hudson_edge_woocommerce_content')){

    /**
     * Output WooCommerce content.
     *
     * This function is only used in the optional 'woocommerce.php' template
     * which people can add to their themes to add basic woocommerce support
     * without hooks or modifying core templates.
     *
     * @access public
     * @return void
     */
    function hudson_edge_woocommerce_content() {

        if ( is_singular( 'product' ) ) {

            while ( have_posts() ) : the_post();

				wc_get_template_part( 'content', 'single-product' );

            endwhile;

        } else {

            ?>

            <?php do_action( 'woocommerce_archive_description' ); ?>

            <?php if ( have_posts() ) : ?>

                <?php do_action('woocommerce_before_shop_loop'); ?>

                <?php woocommerce_product_loop_start(); ?>

                    <?php woocommerce_product_subcategories(); ?>

                    <?php while ( have_posts() ) : the_post(); ?>

                        <?php wc_get_template_part( 'content', 'product' ); ?>

                    <?php endwhile; // end of the loop. ?>

                <?php woocommerce_product_loop_end(); ?>

                <?php do_action('woocommerce_after_shop_loop'); ?>

            <?php elseif ( ! woocommerce_product_subcategories( array( 'before' => woocommerce_product_loop_start( false ), 'after' => woocommerce_product_loop_end( false ) ) ) ) : ?>

                <?php wc_get_template_part( 'loop/no-products-found.php' ); ?>

            <?php endif;

        }
    }
}
if ( ! function_exists('hudson_edge_woocommerce_output_product_data_tabs') ) {

	/**
	 * Output the product tabs.
	 *
	 * @access public
	 * @subpackage	Product/Tabs
	 * @return void
	 */
	function hudson_edge_woocommerce_output_product_data_tabs() {
		wc_get_template( 'single-product/tabs/tabs.php' );
                echo '</div>';
	}
}


if(!function_exists('hudson_edge_woocommerce_change_actions_priorities')) {
    /**
     * Function that changes woocommerce actions priorities.
     * Used in product listing to put product rating bellow product price
     */
    function hudson_edge_woocommerce_change_actions_priorities() {
        $actions = array(
            array(
                'tag' => 'woocommerce_after_shop_loop_item_title',
                'action' => 'woocommerce_template_loop_price',
                'priority' => 10,
                'priority_to_set' => 10
            ),
            array(
                'tag' => 'woocommerce_after_shop_loop_item_title',
                'action' => 'woocommerce_template_loop_rating',
                'priority' => 5,
                'priority_to_set' => 11
            )
        );
        
        foreach($actions as $action) {
            //actions which priorities needs to be changed
            remove_action($action['tag'], $action['action'], $action['priority']);
            
            //new priorities
            add_action($action['tag'], $action['action'], $action['priority_to_set']);
        }
    }
    
    add_action('woocommerce_change_priorities', 'hudson_edge_woocommerce_change_actions_priorities');
    do_action('woocommerce_change_priorities');
}

add_filter( 'get_product_search_form' , 'hudson_edge_woo_product_searchform');

/**
 * woo_custom_product_searchform
 *
 * @access      public
 * @since       1.0
 * @return      void
 */
function hudson_edge_woo_product_searchform($form) {

    $form = '<form method="get" id="searchform" action="' . esc_url( home_url( '/'  ) ) . '">
		<div>
			<label class="screen-reader-text" for="s">' . esc_html__( 'Search for:', 'hudson' ) . '</label>
			<input type="text" value="' . get_search_query() . '" name="s" id="s" placeholder="' . esc_html__( 'Search Products', 'hudson' ) . '" />
			<input type="submit" id="searchsubmit" value="&#xf002" />
			<input type="hidden" name="post_type" value="product" />
		</div>
	</form>';

    return $form;

}

if(!function_exists('hudson_edge_woocommerce_share')) {
    function hudson_edge_woocommerce_share() {
        global $hudson_edge_options;

        $product_show_social_share = "no";
        if (isset($hudson_edge_options['enable_social_share'])&& ($hudson_edge_options['enable_social_share']) =="yes"){
            if (isset($hudson_edge_options['post_types_names_product'])&& $hudson_edge_options['post_types_names_product'] =="product"){
                if (isset($hudson_edge_options['woo_product_single_show_social_share'])) {
                    $product_show_social_share = $hudson_edge_options['woo_product_single_show_social_share'];

                    $product_social_share_type = "dropdown";
                    if(isset($hudson_edge_options['woo_product_single_select_share_option'])){
                        $product_social_share_type = $hudson_edge_options['woo_product_single_select_share_option'];
                    }
                }
            }
        }
        if( hudson_edge_is_core_installed() && $product_show_social_share == 'yes'){
            if($product_social_share_type == 'dropdown'){
                if(do_shortcode('[no_social_share]') != ""){
                    echo '<span class="socail_share_title">' . esc_html__( 'Share: ', 'hudson' ) . '</span>';
                    echo do_shortcode('[no_social_share]'); // XSS OK
                }
            }
            elseif($product_social_share_type == 'list'){
                if(do_shortcode('[no_social_share_list]') != ""){
                    echo '<div class="social_share_list_holder">';
                    echo do_shortcode('[no_social_share_list]'); // XSS OK
                    echo '</div>'; // close social_share_list_holder
                }
            }
        }

    }

    add_action('woocommerce_product_meta_end', 'hudson_edge_woocommerce_share');
}

if(!function_exists('hudson_edge_woocommerce_before_thumbnails')){
	function hudson_edge_woocommerce_before_thumbnails(){
		print '<div class="thumbnails columns-3">';
	}
	add_action( 'woocommerce_product_thumbnails', 'hudson_edge_woocommerce_before_thumbnails', 15 );
}

if(!function_exists('hudson_edge_woocommerce_after_thumbnails')){
	function hudson_edge_woocommerce_after_thumbnails(){
		print '</div>';
	}
	add_action( 'woocommerce_product_thumbnails', 'hudson_edge_woocommerce_after_thumbnails', 25 );
}


